
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Server Calls - used to retrieve XML from server
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

sawr = function() { }

////////////////////////////////////////////////////////////////////////////////////
// saw server request obj
sawr.serverRequests = new Array();

//public - outbound
sawr.serverRequest = function(sUrl, fCallback)
{
	this.sUrl = saw.commandToURL(sUrl, true);
	this.fCallback = fCallback;
	this.tCallerObj = null;
	this.fFatalErrorHandler = null;
	this.fNonFatalErrorHandler = null;
	this.tContextInfo = null;
	this.sGroup = null;
   
   this.fWaitHandler = null;
   this.nWaitInterval = 500;

	this.sData = "";
}

// sets sData with a string of args of the form key1=value2&key2=value3...
sawr.serverRequest.prototype.setArgString = function(sArgs) 
{
   this.sData = sArgs;
}

//adds single http arg with name sKey with value sValue
sawr.serverRequest.prototype.addArg = function(sKey, sValue) 
{
   //TODO: check to see whether arg already exists
   if (this.sData)
      this.sData += "&";
   
   this.sData += saw.encodeURIComponent(sKey) + "=" + saw.encodeURIComponent(sValue);
}

//posts single http arg named XML with value as string form of the xml
//example: <blah>hi</blah> is submitted as XML=%3Cblah%3Ehi%3C/blah%3E
sawr.serverRequest.prototype.addXmlElementArg = function(tElement) 
{
	this.sData += "XML=" + saw.encodeURIComponent(tElement.xml);
}


//optional config
// if fatal error occurred
sawr.serverRequest.prototype.setFatalErrorHandler = function(fErrorHandler) //default will alert error message
{
	this.fFatalErrorHandler = fErrorHandler;
}

// if non-fatal error occurred
sawr.serverRequest.prototype.setNonFatalErrorHandler = function(fErrorHandler) //default will alert error message
{
	this.fNonFatalErrorHandler = fErrorHandler;
}

// if you don't care if fatal or not
sawr.serverRequest.prototype.setErrorHandler = function(fErrorHandler) //default will alert error message
{
	this.fNonFatalErrorHandler = fErrorHandler;
	this.fFatalErrorHandler = fErrorHandler;
}

// handler to be called while request is still waiting 
sawr.serverRequest.prototype.setWaitHandler = function(fWaitHandler, nInterval) //default will alert error message
{
	this.fWaitHandler = fWaitHandler;
   if (nInterval) 
      this.nWaitInterval = nInterval;
}

sawr.serverRequest.prototype.setCallerObj = function(tCallerObj)
{
	this.tCallerObj = tCallerObj;
}


sawr.serverRequest.prototype.setContextInfo = function(tContextInfo)
{
	this.tContextInfo = tContextInfo;
}

sawr.serverRequest.prototype.setGroup = function(sGroup)
{
	this.sGroup = sGroup;
}

sawr.serverRequest.prototype.equals = function(tRequest)
{
	if (!tRequest)
		return false;

//alert(this.sUrl + " " + tRequest.sUrl);
//alert(this.fCallback + " " + tRequest.fCallback);
//alert(this.tCallerObj + " " + tRequest.tCallerObj);
//alert(this.fFatalErrorHandler + " " + tRequest.fFatalErrorHandler);
//alert(this.fNonFatalErrorHandler + " " + tRequest.fNonFatalErrorHandler);
//alert(this.sData + " " + tRequest.sData);
//alert(this.tContextInfo + " " + tRequest.tContextInfo);
//alert(this.tForm + " " + tRequest.tForm);
	//TODO: check header array, context object (actual), and callerObj (actual)
	return this.sUrl == tRequest.sUrl && this.fCallback == tRequest.fCallback &&
		this.tCallerObj == tRequest.tCallerObj && this.fFatalErrorHandler == tRequest.fFatalErrorHandler && 
		this.fNonFatalErrorHandler == tRequest.fNonFatalErrorHandler &&
		this.sData == tRequest.sData && this.tForm == tRequest.tForm &&
		this.tContextInfo == tRequest.tContextInfo;
}

sawr.serverRequest.prototype.clone = function()
{
   var tReq = new sawr.serverRequest(this.sUrl, this.fCallback);
   for (i in this) {
        tReq[i] = this[i];
   }
   return tReq;
}

// private
sawr.serverRequest._addRequest = function(tRequest)
{
	var i;
	for (i=0; i<sawr.serverRequests.length; i++)
	{
		if (sawr.serverRequests[i])
			break;
	}

	if (i==sawr.serverRequests.length)
	{
		sawr.serverRequests = new Array();
	}

   //TODO: copy request instead of using the caller controlled ref
	sawr.serverRequests[sawr.serverRequests.length] = tRequest;
}



////////////////////////////////////////////////////////////////////////////////////
// response class
// req is calling saw.serverRequest obj
// xmlResponse is an XMLDocument containing response xml
sawr.serverResponse = function(sawrServerRequest, xmlResponse)
{
   if (sawrServerRequest)
   	this.req = sawrServerRequest;
	if (xmlResponse)
   	this.xmlResponse = xmlResponse.selectSingleNode("sawr:response");
}

//private - primary response function - processes and routes response
sawr.serverResponse.prototype.processResponse = function()
{
	var req = this.req;

	if (this.validate())
	{	
	   var tData = new sawr.responseData(req.tCallerObj, this.getXML(), this.getHTML(), this.getScript(), req.tContextInfo);
		if (req.fCallback)
		{
			req.fCallback(tData);
		}
		if (req.fNonFatalErrorHandler)
		{
			var aNonFatal = this.getSAWExceptions(false);
			if (aNonFatal)
   			req.fNonFatalErrorHandler(tData, aNonFatal);
		}

	}
	else
	{
		var tData = new sawr.responseData(req.tCallerObj, null, null, req.tContextInfo);
		
		var aFatal = this.getSAWExceptions(true);
		if (req.fFatalErrorHandler && aFatal)
		{
			req.fFatalErrorHandler(tData, aFatal);
		}
		else
			sawr.serverResponse.defaultErrorHandler(tData, aFatal);
	}
}

sawr.serverResponse.evalResponseScript = function(tData)
{
   if (tData.getScript())
      eval(tData.getScript());
}

sawr.serverResponse.prototype.validate = function()
{
	if (this.xmlResponse && !this.xmlResponse.selectSingleNode("sawr:exception[@fatal=\"true\"]"))
	{
		return true;
	}
	return false;
}

sawr.serverResponse.prototype.getXML = function(xml)
{
	return this.xmlResponse.selectSingleNode("sawr:responseXML");
}

sawr.serverResponse.prototype.getHTML = function(xml)
{
	var temp = this.xmlResponse.selectSingleNode("sawr:responseHTML");
	if (temp)
	   return XUIGetElementText(temp);
	else 
	   return temp;
}

sawr.serverResponse.prototype.getScript = function(xml)
{
   var temp = this.xmlResponse.selectSingleNode("sawr:responseScript");
	if (temp)
	   return XUIGetElementText(temp);
	else 
	   return temp;
}

sawr.serverResponse.prototype.getSAWExceptions = function(bFatal)
{
	if (!this.xmlResponse)
		return;
		
	var xPath
	if (bFatal)
		xPath = "sawr:exception[@fatal=\"true\"]";
	else
		xPath = "sawr:exception[@fatal=\"false\"]";

	var aNodes = this.xmlResponse.selectNodes(xPath);
	if (aNodes && aNodes.length > 0)
	{
		var aExceptions = new Array();
		for (var i=0; i<aNodes.length; i++)
		{
			aExceptions[aExceptions.length] = sawr.exception.createFromNode(aNodes[i]);
		}
		return aExceptions;
	}
	return null;
}

sawr.serverResponse.defaultErrorHandler = function(tData, aFatal)
{
	if (aFatal && aFatal[0])
	{
		alert(aFatal[0].getType() + " : " + aFatal[0].getMessage());
	}
	else
		alert("There was an unknown error with the server call");
}

sawr.serverResponse.createGenericException = function(sText)
{
   var tDoc = saw.createXMLDocument(document);
   var tResponse = tDoc.appendChild(XUICreateElement(saw.xml.kSawrNamespace, "response"));
   var tException = tResponse.appendChild(XUICreateElement(saw.xml.kSawrNamespace, "exception"));
   tException.setAttribute("fatal", "true");
   var tType = tException.appendChild(XUICreateElement(saw.xml.kSawrNamespace, "type"));
   tType.appendChild(XUICreateTextNode("error"));
   var tMessage = tException.appendChild(XUICreateElement(saw.xml.kSawrNamespace, "message"));
   if (sText != null)
      tMessage.appendChild(XUICreateTextNode(sText));
   else
      tMessage.appendChild(XUICreateTextNode("Response from server contained an error"));
   
   return tDoc;
}

/////////////////////////////////////////////////////////////////
// object passed into callback function
sawr.responseData = function(tCallerObj, tXML, sHTML, sScript, tContextInfo)
{
	this.tCallerObj = tCallerObj;
	this.tXML = tXML;
	this.sHTML = sHTML;
	this.sScript = sScript;
	this.tContext = tContextInfo;
}

sawr.responseData.prototype.setCallerObj = function(tObj)
{
	this.tCallerObj = tObj;
}
sawr.responseData.prototype.getCallerObj = function()
{
	return this.tCallerObj;
}

sawr.responseData.prototype.setXML = function(tXML)
{
	this.tXML = tXML;
}
sawr.responseData.prototype.getXML = function()
{
	return this.tXML;
}

sawr.responseData.prototype.setHTML = function(sHTML)
{
	this.sHTML = sHTML;
}
sawr.responseData.prototype.getHTML = function()
{
	return this.sHTML;
}
// returns document fragment with single div at root.  html data is contained withinDiv
sawr.responseData.prototype.getHTMLInDocument = function(tDoc)
{
   var tLoadingDoc = tDoc;
   if (!tLoadingDoc)
      tLoadingDoc = document.createDocumentFragment();
   
   //if iframe has already been usd to load html
   var tDiv = tLoadingDoc.getElementById("idResponseHTMLDiv");
   if (tDiv)
   {
      while (tDiv.childNodes.length)
         tDiv.removeChild(tDiv.firstChild);
   }
   else
      tDiv = tLoadingDoc.createElement("div");
   tDiv.id = "idResponseHTMLDiv";
   if (tDiv.style)
      tDiv.style.display = "none";
   
   if (tLoadingDoc.body)
      tLoadingDoc.body.appendChild(tDiv);
   else
      tLoadingDoc.appendChild(tDiv);

   //GF: For browser portability and consistency with the use of scripts, 
   //    innerHTML must be set after appendChild.
   tDiv.innerHTML = this.getHTML();
   return tLoadingDoc;
}


sawr.responseData.prototype.setScript = function(sScript)
{
	this.sScript = sScript;
}
sawr.responseData.prototype.getScript = function()
{
	return this.sScript;
}
// returns document fragment with single div at root.  script data is contained withinDiv
// script in document HAS NOT been evaluated.
sawr.responseData.prototype.getScriptInDocument = function(tDoc)
{
   var tLoadingDoc = tDoc;
   if (!tLoadingDoc)
      tLoadingDoc = is_ie ? document.createDocumentFragment() : document.implementation.createDocument("", "", null);
   var tDiv = document.createElement("div");
   tDiv.id = "idResponseScriptDiv";
   tDiv.style.display = "none";
   //for some reason this is needed
   var sHTML="<BR>";
   tDiv.innerHTML = sHTML + this.getScript();
   tLoadingDoc.appendChild(tDiv);
   return tLoadingDoc;
}

sawr.responseData.prototype.setContextInfo = function(aInfo)
{
	this.tContext = aInfo;
}
sawr.responseData.prototype.getContextInfo = function(aInfo)
{
	return this.tContext;
}



//callback sig
//htmlData will be HTML in <responseHTML> node of response
//xmlData will be XML in <responseXML> node of response
//response script will have already been evaluated
//fCallBack(sawr.responseData);

//error handler sig
//function passed array of sawr.exception objects
//default will open an alert for each exception
//fErrorHandler(aExceptions);


// Exception class
// this needs to be worked on more and made for general usage
sawr.exception = function(sType, sMessage)
{
	this.sType = sType;
	this.sMessage = sMessage;
}

sawr.exception.createFromNode = function(tExceptionNode)
{
	var sType;
	var tType = tExceptionNode.selectSingleNode("sawr:type");
	if (tType)
		sType = XUIGetElementText(tType);
	else
		sType = "Unknown Exception";

	var sMessage;
	var tMsg = tExceptionNode.selectSingleNode("sawr:message");
	if (tMsg)
		sMessage = XUIGetElementText(tMsg);
	else
		sMessage = "";

	return new sawr.exception(sType, sMessage);
}

sawr.exception.createFromArray = function(aError)
{
	return new sawr.exception(aError[1], aError[2]);
}

sawr.exception.prototype.getType = function()
{
	return this.sType;
}

sawr.exception.prototype.getMessage = function()
{
	return this.sMessage;
}


////////////////////////////////////////////////////////////
// abstract class for server request connections to SAW
//////////////////////////////////////////////////////////W
sawr.connection = function()
{
}

sawr.connection.prototype.super_init = function(tRequest) 
{
	this.req = tRequest.clone();

	this.bIgnoreSame = true;
	this.bEnforceOrder = false;
}

//request ready states
sawr.connection.uninitialized = 0;
sawr.connection.loading = 1;
sawr.connection.loaded = 2;
sawr.connection.interactive = 3;
sawr.connection.complete = 4;


// if true, ignores additional requests that are exactly the same until this one is done
sawr.connection.prototype.ignoreSame = function(bIgnore)
{
	this.bIgnoreSame = bIgnore;
}

// does not process response until all previous requests of the same sGroup are completed
// TODO: not implemented yet
sawr.connection.prototype.enforceOrder = function(bEnforceOrder)
{
	this.bEnforceOrder = bEnforceOrder;
}

//submit functions - return true or false depending on successful connection
sawr.connection.prototype.get = function()
{
	return this._submitType("get");
}

// posts request with any args that have been added to request
sawr.connection.prototype.post = function() 
{
	return this._submitType("post");
}

sawr.connection.prototype.postForm = function(tForm)
{
	this.req.tForm = tForm;
	return this.post();
}

//sData is of form key1=value1&key2=value2
//key and value must be UTF-8 encoded (saw.encodeURIComponent)
sawr.connection.prototype.postStringData = function(sData) 
{
	this.req.sData = sData;
	return this.post();
}

sawr.connection.prototype._submitType  =function(sType)
{
	this.submitMethod = sType;
	if (!this._validate()) return;

	sawr.serverRequest._addRequest(this.req);

   this._preSubmit();

	var bSuccess = this._submit();

   if (bSuccess)
      this._postSubmit();
   return bSuccess;
}

//curently only checks to see if it should ignore the request
sawr.connection.prototype._validate = function()
{
	if (!this.bIgnoreSame)
		return true;

	for (var i=0; i<sawr.serverRequests.length; i++)
	{
		if (this.req.equals(sawr.serverRequests[i]))
			return false;
	}
	return true;
}

sawr.connection.prototype._submit = function(sType, tRequest) { alert("virtual function, _submit, must be implemented by connection"); }

sawr.connection.prototype._preSubmit = function() {}

sawr.connection.prototype._postSubmit = function()
{
   this._startRequestWatcher(this.req);
}

sawr.connection.prototype._startRequestWatcher = function(req)
{
   var conn = this;
   if (req.fWaitHandler)
   {
      var fWaitHandler = req.fWaitHandler;
      req.sIntervalID = window.setInterval(
         function(){
            if(conn.requestInProgress(req))
               fWaitHandler(req);
            }
      ,req.nWaitInterval);
   }
}


sawr.connection.prototype.requestInProgress = function(req)
{
   return (this._getReadyState(req) != sawr.connection.uninitialized && this._getReadyState(req) != sawr.connection.complete);
}

// this shold be overriden by connection
sawr.connection.prototype._getReadyState = function(req)
{
   alert("virtual function, _getReadyState, must be implemented by connection");
}

///////////////////////////////////////////////////////////////////////
// servercall iframe request
// adds to back button history
//-----------------
var aAjaxErrors = new Array();
//
sawr.iFrameConnection = function(tRequest)
{
	this.super_init(tRequest);
	this.uid = "idsawr.connection";
	this.bVisible = false;
}

sawr.iFrameConnection.prototype = new sawr.connection();

sawr.iFrameConnection.prototype.setID = function(sID)
{
	this.uid = sID
}

sawr.iFrameConnection.prototype.setVisible = function(bVisible)
{
	this.bVisible = bVisible;
}

//////////////////////////////////////////////////////////
//private functions
//////////////////////////////////////////////////////////
sawr.iFrameConnection.prototype._submit = function()
{
   var iframeID = this.uid + "IFrame";

   var tIFrame = document.getElementById(iframeID);

   if (tIFrame == null)
   {
      tIFrame = saw.createHiddenIFrame(iframeID, iframeID);

      // For debugging
      if (this.bVisible)
      {
         tIFrame.style.display = '';
         tIFrame.style.visibility = "visible";
         tIFrame.style.height = '300px';
         tIFrame.style.width = '300px';
      }
   }

   tIFrame.serverRequest = this.req;
   this.req.iframeID = iframeID;

   //TODO: investigate what this does
   // save caller and specified context
   //	var caller = tRequest.tCallerObj;
   //	if (caller)
   //    caller.panel.disable();

   saw.addEventListener(tIFrame, 'load', sawr.iFrameConnection._onLoad)

   if (this.submitMethod == "post")
   {
      var tForm = this.req.tForm;
      if (!tForm)
      {
         this.req.addArg("ajaxType", "iframe");
         tForm = saw.createFormFromString(this.req.sData);
      }
      else
         saw.addHiddenInput(tForm, "ajaxType", "iframe");

      //the original form should not be modified for this ajax call
      var tFormOriginalTarget = tForm.target;
      var tFormOriginalMethod = tForm.method;
      var tFormOriginalAction = tForm.action;

      tForm.target = tIFrame.id;
      tForm.method = this.submitMethod;
      tForm.action = this.req.sUrl;

      tForm.submit();

      //Restoring the original Form.
      tForm.target = tFormOriginalTarget;
      tForm.method = tFormOriginalMethod;
      tForm.action = tFormOriginalAction;
   }
   else
      tIFrame.src = this.req.sUrl + "&ajaxType=iframe";

   return true;
}

// event is not attached to target when using event listener
sawr.iFrameConnection._onLoad = function(event)
{
   var sIFrameID = saw.getEventCurrentTarget(event).id;
   var tIFrame = window.frames[sIFrameID];
   var tRequest = document.getElementById(sIFrameID).serverRequest;

   //unregister the onLoad for this frame
   if (tIFrame != null && tIFrame.frameElement)
      saw.removeEventListener(tIFrame.frameElement, 'load', sawr.iFrameConnection._onLoad);

   if ((tIFrame != null) && (tRequest != undefined))
   {
      if (tIFrame.src && tIFrame.src != tRequest.sUrl)
         return;

      var tResponse = null;
      try
      {
         //tResponse = saw.createXMLDocument(document);
         // document.getElementById(sIFrameID).serverRequest = null;
         //if (!tResponse.loadXML(tIFrame["idXML"]))
         //   tResponse = sawr.serverResponse.createGenericException();
         if (tIFrame["idXML"] || tIFrame["idHTML"] || tIFrame["idScript"])
            (new sawr.ifServerResponse(tRequest, tIFrame["idXML"], tIFrame["idHTML"], tIFrame["idScript"])).processResponse();
         else if (tIFrame["aAjaxErrors"])
         {
            aAjaxErrors = tIFrame["aAjaxErrors"];
            (new sawr.ifServerResponse(tRequest)).processResponse();
         }
         else if (tIFrame.src != "empty.htm" && !tIFrame['sawAjaxEmptyResponseFlag'])
         {
            sawr.ifServerResponse.createGenericException();
            (new sawr.ifServerResponse(tRequest)).processResponse();
         }
      }
      catch(e)
      {
         alert(saw.getExceptionMessage(e));
      }

      //GF:  after the error is displayed or used in any way, clean it so that the next 
      //     ajax call doesn't get confused by the error of the previous connection.
      //Todo: handle the iFrameAjax errors in a better way. Allow simultaneous ajax connections.
      aAjaxErrors = [];

      //if (tCaller.caller)
      // tCaller.caller.panel.enable();
      for (var i=0; i<sawr.serverRequests.length; i++)
      {
         if (sawr.serverRequests[i] == tRequest)
         {
            if (sawr.serverRequests[i].sIntervalID)
               window.clearInterval(sawr.serverRequests[i].sIntervalID);
            sawr.serverRequests[i] = null;
            delete sawr.serverRequests[i];
         }
      }
   }
}

sawr.iFrameConnection.prototype._getReadyState = function(req)
{
   var tIFrame = window.frames[req.iframeID];
   return tIFrame.readyState;
}

sawr.iFrameConnection.getIFrame = function(sID)
{
   var iframeID = sID + "IFrame";
   var tIFrame = window.frames[sID + "IFrame"];
   //if (!tIFrame)
   //   tIFrame = saw.createHiddenIFrame(sID + "IFrame", sID + "IFrame");
   return tIFrame;
}

/////////////////////////////////////////////////////////////////////
////SAW XMLHTTPREQUEST CALLS
/////////////////////////////////////////////////////////////////////
sawr.xhrConnection = function(tRequest)
{
	this.super_init(tRequest);

	this.aHeader = new Array(); 
   this.bSync = false;
}

sawr.xhrConnection.prototype = new sawr.connection();

//optional outbound config for xmlhttprequest
sawr.xhrConnection.prototype.addHeader = function(sKey, sValue)
{
	this.aHeader[sKey] = sValue;
}

// WARNING! Synchronous requests lock entire browser (back button, page interaction, file menu), so this should be used judiciously
sawr.xhrConnection.prototype.setSync = function(bUseSync)
{
	this.bSync = bUseSync;
}

//////////////////////////////////////////////////////////
//private functions
//////////////////////////////////////////////////////////
sawr.xhrConnection.prototype._submit = function()
{
   var url = this.req.sUrl;
   var processMethod = this.req.fCallback;
   var headArray = this.req.aHeader;

   // branch for native XMLHttpRequest object
   var xhr = sawr.xhrConnection._getXmlHttpReq();

   if (xhr) 
   {
      this.req.xhr = xhr;
      this.req.getReadyState = function() { return xhr.readyState; }
      
      if (!this.bSync)
         xhr.onreadystatechange = sawr.xhrConnection._processReqChange;

      xhr.open(this.submitMethod, url, !this.bSync);
      if(this.submitMethod == "post")
         xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
         
      var i = 0;
      var len  = 0;
      if(headArray)
      {
         for (i =0; i < headArray.length; ++i)
         {
             var node = headArray[i];
             xhr.setRequestHeader(node.name, node.value);
         }
      }
      var queryStr = "";
      if (this.req.tForm)
      {
         saw.addHiddenInput(this.req.tForm, "ajaxType", "xhr");
         queryStr = saw.convertFormToString(this.req.tForm);         
      }
      else
         queryStr = this.req.sData;
      
      if (this.submitMethod == 'post' && queryStr && queryStr.indexOf('icharset') == -1)
      {
         queryStr += "&icharset=utf-8";
      }
      xhr.send(queryStr);
      
      if (this.bSync)
         sawr.xhrConnection._processReqChange();
   }

   return true;
}

sawr.xhrConnection._getXmlHttpReq = function()
{
   var xmlHttp = null;
   if (window.XMLHttpRequest)
	  xmlHttp = new XMLHttpRequest();
   else if (window.ActiveXObject)
	  xmlHttp = new ActiveXObject("Microsoft.XMLHTTP"); 
	
   return xmlHttp;
}


sawr.xhrConnection._processReqChange = function() 
{    
   var i = 0;
	for (i=0; i<sawr.serverRequests.length ; i++)
	{
		if (!sawr.serverRequests[i])
			continue;
		var tReq = sawr.serverRequests[i];

      if (tReq.bProcessingComplete != null && tReq.bProcessingComplete == true)
         continue;

		var xhr = tReq.xhr;
		if (!xhr)
			continue;

		if (xhr.readyState == sawr.connection.complete) 
		{
         tReq.bProcessingComplete = true;

			// only if "OK"
			if (xhr.status == 200) 
			{
				var xmlDoc = xhr.responseXML;
				if (xmlDoc && xmlDoc.xml)
				{		
					(new sawr.serverResponse(tReq, xmlDoc)).processResponse();
			   }
				else if (xhr.responseText)
				{
					(new sawr.serverResponse(tReq, sawr.serverResponse.createGenericException("(Response came back as text, not XML) "))).processResponse();
				}
				else
				{
					(new sawr.serverResponse(tReq, sawr.serverResponse.createGenericException("Empty response from Oracle BI Presentation Services"))).processResponse();
   			}
			} 
			else 
			{
				alert("There was a problem retrieving the XML data:\n" + xhr.statusText);
			}

			xhr = null;
			tReq.xhr = null;
         if (tReq.sIntervalID)
            window.clearInterval(tReq.sIntervalID);
         tReq = null;
			sawr.serverRequests[i] = null;
			delete sawr.serverRequests[i];
		}
	}
}

sawr.xhrConnection.prototype._getReadyState = function(req)
{
   return req.xhr.readyState;
}




////////////////////////////////////////////////////////////////////////////////////
// response class
// req is calling saw.serverRequest obj
// xmlResponse is an XMLDocument containing response xml
sawr.ifServerResponse = function(sawrServerRequest, sXML, sHTML, sScript)
{
	this.req = sawrServerRequest;
	//this.xmlResponse = xmlResponse.selectSingleNode("sawr:response");
	this.sXML = sXML;
	this.sHTML = sHTML;
	this.sScript = sScript;
}

sawr.ifServerResponse.prototype = new sawr.serverResponse();


sawr.ifServerResponse.prototype.validate = function()
{
   return aAjaxErrors.length == 0;
}

sawr.ifServerResponse.prototype.getXML = function(xml)
{
	return this.sXML;
}

sawr.ifServerResponse.prototype.getHTML = function(xml)
{
	return this.sHTML;
}

sawr.ifServerResponse.prototype.getScript = function(xml)
{
	return this.sScript;
}

sawr.ifServerResponse.prototype.getSAWExceptions = function(bFatal)
{
   if (aAjaxErrors && aAjaxErrors.length > 0)
	{
		var aExceptions = new Array();
		for (var i=0; i<aAjaxErrors.length; i++)
		{
			aExceptions[aExceptions.length] = sawr.exception.createFromArray(aAjaxErrors[i]);
		}
		return aExceptions;
	}
	return null;
}

sawr.ifServerResponse.createGenericException = function()
{   
   if (!aAjaxErrors) 
      aAjaxErrors=new Array(); 
   aAjaxErrors.push([true, 'Error', 'Response from server contained an error']);
   
   return aAjaxErrors;
}